#ifndef GST_GeoTagProfles_hpp__
#define GST_GeoTagProfles_hpp__

#include "buildspec.h"
#include <vector>

namespace GST
{
namespace Geometry
{
namespace GeoTagProfiles
{
struct Point2d
{
	double x;
	double y;
	Point2d() : x(0), y(0)
	{
	}
	Point2d(const double x, const double y) : x(x), y(y)
	{
	}
};
struct Point3d
{
	double x;
	double y;
	double z;
	Point3d() : x(0), y(0), z(0)
	{
	}
	Point3d(const double x, const double y, const double z) : x(x), y(y), z(z)
	{
	}
};

// A LineString is a Curve with linear interpolation between Points. Each
// consecutive pair of Points defines a Linesegment

struct Linestring2d
{
	std::vector<Point2d> points;
};

struct Linestring3d
{
	std::vector<Point3d> points;
};

// A MultiLineString string consists of multiple LineStrings

struct MultiLineString2d
{
	std::vector<Linestring2d> lineStrings;
};

struct MultiLineString3d
{
	std::vector<Linestring3d> lineStrings;
};

struct ProfileInfo
{
	// scale: image unit to real word unit factor
	//  1 image unit represents this many real world units
	double scale;
	// verticalExaggeration: exaggeration factor for y-coordinate of image
	//  image y-coordinates are scaled by the scale-factor above and
	//  additionally multiplied by the verticalExaggeration factor
	double verticalExaggeration;
	// marginOfError: for comparing referenceLine length to maximum spread of
	// profileLines
	//  marginOfError < 0: criterium does not apply
	double marginOfError;
	ProfileInfo() : scale(1), verticalExaggeration(1), marginOfError(-1)
	{
	}
};

struct Profile
{
	// has scale / vertical exaggeration info
	ProfileInfo profileInfo;
	// these are in image units
	std::vector<MultiLineString2d> profileLines;
	// this is in real world units
	Linestring2d referenceLine;
};

class MarginOfErrorExceeded
{
};

GST_API_EXPORT std::vector<MultiLineString3d> getGeoTagProfile(
	const Profile &profile);
} // namespace GeoTagProfiles
} // namespace Geometry
} // namespace GST
#endif // GST_GeoTagProfles_hpp__
